Rem
Rem Copyright (c) 2003, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      create_conversion.sql - create LCR transformations for this sample.
Rem
Rem    DESCRIPTION
Rem      This script creates two transformations for LCR converion between
Rem      in sys.anydata format and in sys.mgw_tibrv_msg_t format. 
Rem
Rem


connect mgwadm/mgwadm
set serveroutput on

Rem
Rem Create a function to conver a LCR to an object of sys.mgw_tibrv_msg_t type.
Rem
create or replace function any2tibrv(adata in sys.anydata)
return sys.mgw_tibrv_msg_t is
    v_xml   XMLType;
    v_text  varchar2(2000);
    v_tibrv sys.mgw_tibrv_msg_t;
begin
    v_xml   := dbms_mgwmsg.lcr_to_xml(adata);

    -- assume the lcr is smaller than 2000 characters long.
    v_text  := v_xml.getStringVal();

    v_tibrv := sys.mgw_tibrv_msg_t.construct;

    v_tibrv.add_string('ORACLE_LCR', 0, v_text);

    return v_tibrv;

end any2tibrv;
/


Rem
Rem Grant execute permission to everyone.
Rem
grant execute on any2tibrv to public;


Rem
Rem Create a function to conver an object of sys.mgw_tibrv_msg_t type to LCR.
Rem
create or replace function tibrv2any(tdata in sys.mgw_tibrv_msg_t)
return sys.anydata is
    v_field   sys.mgw_tibrv_field_t;
    v_xml     XMLType;
    v_text    varchar2(2000);
    v_any     sys.anydata;
begin
    v_field := tdata.get_field_by_name('ORACLE_LCR');

    -- type checking
    v_text  := v_field.text_value;

    -- assume it is not null
    v_xml  := XMLType.createXML(v_text);

    v_any  := dbms_mgwmsg.xml_to_lcr(v_xml);

    return v_any;
end tibrv2any;
/

Rem
Rem Grant execute permission to everyone.
Rem
grant execute on tibrv2any to public;

Rem
Rem Create the transformations that calls the two functions above.
Rem
Rem
begin
  dbms_transform.create_transformation(
    schema      => 'mgwadm',
    name        => 'lcr2tibrv',
    from_schema => 'sys',
    from_type   => 'anydata',
    to_schema   => 'sys',
    to_type     => 'mgw_tibrv_msg_t',
    transformation => 'mgwadm.any2tibrv(source.user_data)');

  dbms_transform.create_transformation(
    schema      => 'mgwadm',
    name        => 'tibrv2lcr',
    from_schema => 'sys',
    from_type   => 'mgw_tibrv_msg_t',
    to_schema   => 'sys',
    to_type     => 'anydata',
    transformation => 'mgwadm.tibrv2any(source.user_data)');

end;
/

